uniform sampler2D texture0;	// depth texture
uniform sampler2D rotMap;	// rotation normal map

//uniform vec2 camerarange; 	// near and far camera range
//uniform vec2 screensize;	// screen width and height
varying vec2 	texCoord;
varying vec2	texCoord1;
uniform vec3 	shk[8];		// sphere kernel

uniform float	wFar;

float aoCap = 1.0;
float aoMultiplier=1.0;
float depthTolerance=0.0;
uniform float aorange;//= 300.0;// units in space the AO effect extends to (this gets divided by the camera far range

float invAOrange=1.0/aorange;//0.005;	//1/aorange;	

uniform float contrast;

/*float lerp(float a, float b, float t)
{
	return ((b-a)*t)+a;
}*/

vec3 mirror( vec3 vDir, vec3 vPlane ) 
{
	return (vDir - 2.0 * vPlane * dot(vPlane,vDir))*0.03;
}

float compareDepths( in float depth1, in float depth2 ) 
{
	float distance=depth1-depth2;
	float dscaled=distance*invAOrange;
	float valid=(clamp(abs(dscaled),0.0,1.0)+clamp(dscaled,0.0,1.0))*0.5;
	return 1.0-mix(clamp(-distance*1000.0,0.0,1.0),0.55,valid);
}

void main(void)
{	
	float depth = -texture2D(texture0, texCoord.xy).r;
	
	float d;
	float 	aoscale=1.5,
			aoscale2=1.2;//1.5*0.8;
	float ao=0.0;

	float scale=clamp((depth-aorange),0.0,1.0)*clamp((depth*0.0001),0.0,0.4)+0.6;
	float farscale=scale*3000.0;
	float scale2=scale*2.0;

	// create random rot matrix
	vec3 rotSample = texture2D(rotMap, texCoord1).rgb;
	rotSample = (2.0 * rotSample - 1.0);

	//aorange=200.0;///scale;
	
//	for(int i=0; i<8; i++)
	//{
		vec3 vSample = mirror(shk[0], rotSample);
		vSample.z*=farscale;	// far plane
		
		d=-texture2D( texture0, texCoord.xy+vSample.xy*scale ).z;
		ao+=compareDepths(depth+vSample.z,d)*aoscale;
			
		d=-texture2D( texture0, texCoord.xy+(vSample.xy*scale2)).z;
		ao+=compareDepths(depth+vSample.z,d)*aoscale2;
		
		vSample = mirror(shk[1], rotSample);
		vSample.z*=farscale;	// far plane
		
		d=-texture2D( texture0, texCoord.xy+vSample.xy*scale ).z;
		ao+=compareDepths(depth+vSample.z,d)*aoscale;
			
		d=-texture2D( texture0, texCoord.xy+(vSample.xy*scale2)).z;
		ao+=compareDepths(depth+vSample.z,d)*aoscale2;
		
		vSample = mirror(shk[2], rotSample);
		vSample.z*=farscale;	// far plane
		
		d=-texture2D( texture0, texCoord.xy+vSample.xy*scale ).z;
		ao+=compareDepths(depth+vSample.z,d)*aoscale;
			
		d=-texture2D( texture0, texCoord.xy+(vSample.xy*scale2)).z;
		ao+=compareDepths(depth+vSample.z,d)*aoscale2;
		
		vSample = mirror(shk[3], rotSample);
		vSample.z*=farscale;	// far plane
		
		d=-texture2D( texture0, texCoord.xy+vSample.xy*scale ).z;
		ao+=compareDepths(depth+vSample.z,d)*aoscale;
			
		d=-texture2D( texture0, texCoord.xy+(vSample.xy*scale2)).z;
		ao+=compareDepths(depth+vSample.z,d)*aoscale2;
		
		vSample = mirror(shk[4], rotSample);
		vSample.z*=farscale;	// far plane
		
		d=-texture2D( texture0, texCoord.xy+vSample.xy*scale ).z;
		ao+=compareDepths(depth+vSample.z,d)*aoscale;
			
		d=-texture2D( texture0, texCoord.xy+(vSample.xy*scale2)).z;
		ao+=compareDepths(depth+vSample.z,d)*aoscale2;
		
		vSample = mirror(shk[5], rotSample);
		vSample.z*=farscale;	// far plane
		
		d=-texture2D( texture0, texCoord.xy+vSample.xy*scale ).z;
		ao+=compareDepths(depth+vSample.z,d)*aoscale;
			
		d=-texture2D( texture0, texCoord.xy+(vSample.xy*scale2)).z;
		ao+=compareDepths(depth+vSample.z,d)*aoscale2;
		
		vSample = mirror(shk[6], rotSample);
		vSample.z*=farscale;	// far plane
		
		d=-texture2D( texture0, texCoord.xy+vSample.xy*scale ).z;
		ao+=compareDepths(depth+vSample.z,d)*aoscale;
			
		d=-texture2D( texture0, texCoord.xy+(vSample.xy*scale2)).z;
		ao+=compareDepths(depth+vSample.z,d)*aoscale2;
		
		vSample = mirror(shk[7], rotSample);
		vSample.z*=farscale;	// far plane
		
		d=-texture2D( texture0, texCoord.xy+vSample.xy*scale ).z;
		ao+=compareDepths(depth+vSample.z,d)*aoscale;
			
		d=-texture2D( texture0, texCoord.xy+(vSample.xy*scale2)).z;
		ao+=compareDepths(depth+vSample.z,d)*aoscale2;
//	}

	ao/=16.0;/*24.0;*/
	ao=1.0-(ao*clamp(depth,0.0,1.0));
		
	// brightness & conttrast (default brightness=0.0, contrast=1.0)
	
	ao = ((ao-0.5)*contrast) + 0.5;
	//ao+=0.5;
	ao=clamp(ao,0.0,1.0);
	
	gl_FragColor = vec4(ao);
}